attribute vec3 coord;

#ifdef INSTANCING
attribute mat4 model;
uniform mat4 shadow_vp;
#else
uniform mat4 shadow_mvp;
#endif

#ifdef ALPHA_TEST
attribute vec2 texcoord;
varying vec2 f_texcoord;
#endif

#ifdef ANIMATION
	#if WEIGHT_NUM >= 1
	attribute vec2 weight1;
	#endif
	#if WEIGHT_NUM >= 2
	attribute vec2 weight2;
	#endif
	#if WEIGHT_NUM >= 3
	attribute vec2 weight3;
	#endif
	#if WEIGHT_NUM >= 4
	attribute vec2 weight4;
	#endif
uniform mat4 bone_matrix[BONE_NUM];
#endif

#define GENERAL_WEIGHT_FACTOR 0.3

void main(void)
{
	vec4 actualCoord = vec4(coord, 1.0);

	#ifdef ANIMATION
	vec4 newCoord = vec4(0.0, 0.0, 0.0, 1.0);
	int index;
	float weight = 0.0, weightSum = 0.0;
		#if WEIGHT_NUM >= 1
		index = int(weight1.y);
		weight = weight1.x * GENERAL_WEIGHT_FACTOR;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#endif
		#if WEIGHT_NUM >= 2
		index = int(weight2.y);
		weight = weight2.x * GENERAL_WEIGHT_FACTOR;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#endif
		#if WEIGHT_NUM >= 3
		index = int(weight3.y);
		weight = weight3.x * GENERAL_WEIGHT_FACTOR;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#endif
		#if WEIGHT_NUM >= 4
		index = int(weight4.y);
		weight = weight4.x * GENERAL_WEIGHT_FACTOR;
		weightSum += weight;
		newCoord += weight * (bone_matrix[index]*actualCoord);
		#endif

	float poseFactor = max(0.0, 1.0-weightSum);
	newCoord += poseFactor * actualCoord;
	weightSum += poseFactor;

	float weightSumInverse = 1.0/weightSum;
	actualCoord = vec4(weightSumInverse * newCoord.xyz, 1.0);
	#endif

#ifdef INSTANCING
	gl_Position = shadow_vp * model * actualCoord;
#else
	gl_Position = shadow_mvp * actualCoord;
#endif

#ifdef ALPHA_TEST
	f_texcoord = texcoord;
#endif
}
